/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.common.config.client.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import mod.azure.azurelib.AzureLib;
import mod.azure.azurelib.common.config.ConfigHolderRegistry;
import mod.azure.azurelib.common.config.client.IValidationHandler;
import mod.azure.azurelib.common.config.client.screen.ConfigScreen;
import mod.azure.azurelib.common.config.client.screen.DialogScreen;
import mod.azure.azurelib.common.config.client.widget.ConfigEntryWidget;
import mod.azure.azurelib.common.config.io.ConfigIO;
import mod.azure.azurelib.common.config.validate.NotificationSeverity;
import mod.azure.azurelib.common.config.value.ConfigValue;
import mod.azure.azurelib.common.config.value.ObjectValue;
import net.minecraft.class_2561;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5481;
import net.minecraft.class_757;
import net.minecraft.class_9801;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.joml.Matrix4f;

public abstract class AbstractConfigScreen
extends class_437 {
    public static final int HEADER_HEIGHT = 35;
    public static final int FOOTER_HEIGHT = 30;
    public static final Marker MARKER = MarkerManager.getMarker((String)"Screen");
    protected final class_437 last;
    protected final String configId;
    protected int index;
    protected int pageSize;

    protected AbstractConfigScreen(class_2561 title, class_437 previous, String configId) {
        super(title);
        this.last = previous;
        this.configId = configId;
    }

    public static void renderScrollbar(class_332 graphics, int x, int y, int width, int height, int index, int valueCount, int paging) {
        if (valueCount <= paging) {
            return;
        }
        double step = (double)height / (double)valueCount;
        int min = class_3532.method_15357((double)((double)index * step));
        int max = class_3532.method_15384((double)((double)(index + paging) * step));
        int y1 = y + min;
        int y2 = y + max;
        graphics.method_25294(x, y, x + width, y + height, -16777216);
        graphics.method_25294(x, y1, x + width, y2, -7829368);
        graphics.method_25294(x, y1, x + width - 1, y2 - 1, -1118482);
        graphics.method_25294(x + 1, y1 + 1, x + width - 1, y2 - 1, -3355444);
    }

    public void method_25419() {
        super.method_25419();
        this.saveConfig(true);
    }

    protected void addFooter() {
        int centerY = this.field_22790 - 30 + 5;
        this.method_37063((class_364)class_4185.method_46430((class_2561)ConfigEntryWidget.BACK, this::buttonBackClicked).method_46433(20, centerY).method_46437(50, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)ConfigEntryWidget.REVERT_DEFAULTS, this::buttonRevertToDefaultClicked).method_46433(75, centerY).method_46437(120, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)ConfigEntryWidget.REVERT_CHANGES, this::buttonRevertChangesClicked).method_46433(200, centerY).method_46437(120, 20).method_46431());
    }

    protected void correctScrollingIndex(int count) {
        if (this.index + this.pageSize > count) {
            this.index = Math.max(count - this.pageSize, 0);
        }
    }

    protected class_437 getFirstNonConfigScreen() {
        class_437 screen = this.last;
        while (screen instanceof ConfigScreen) {
            ConfigScreen configScreen = (ConfigScreen)screen;
            screen = configScreen.last;
        }
        return screen;
    }

    private void buttonBackClicked(class_4185 button) {
        this.field_22787.method_1507(this.last);
        this.saveConfig();
    }

    private void buttonRevertToDefaultClicked(class_4185 button) {
        DialogScreen dialog = new DialogScreen(ConfigEntryWidget.REVERT_DEFAULTS, new class_2561[]{ConfigEntryWidget.REVERT_DEFAULTS_DIALOG_TEXT}, this);
        dialog.onConfirmed(screen -> {
            AzureLib.LOGGER.info(MARKER, "Reverting config {} to default values", (Object)this.configId);
            ConfigHolderRegistry.getConfig(this.configId).ifPresent(holder -> {
                this.revertToDefault(holder.values());
                ConfigIO.saveClientValues(holder);
            });
            this.backToConfigList();
        });
        this.field_22787.method_1507((class_437)dialog);
    }

    private void buttonRevertChangesClicked(class_4185 button) {
        DialogScreen dialog = new DialogScreen(ConfigEntryWidget.REVERT_CHANGES, new class_2561[]{ConfigEntryWidget.REVERT_CHANGES_DIALOG_TEXT}, this);
        dialog.onConfirmed(screen -> {
            ConfigHolderRegistry.getConfig(this.configId).ifPresent(ConfigIO::reloadClientValues);
            this.backToConfigList();
        });
        this.field_22787.method_1507((class_437)dialog);
    }

    private void revertToDefault(Collection<ConfigValue<?>> configValues) {
        configValues.forEach(val -> {
            if (val instanceof ObjectValue) {
                ObjectValue objVal = (ObjectValue)val;
                this.revertToDefault(((Map)objVal.get()).values());
            } else {
                val.useDefaultValue();
            }
        });
    }

    private void backToConfigList() {
        this.field_22787.method_1507(this.getFirstNonConfigScreen());
        this.saveConfig();
    }

    private void saveConfig() {
        this.saveConfig(false);
    }

    private void saveConfig(boolean force) {
        if (force || !(this.last instanceof AbstractConfigScreen)) {
            ConfigHolderRegistry.getConfig(this.configId).ifPresent(ConfigIO::saveClientValues);
        }
    }

    public void renderNotification(NotificationSeverity severity, class_332 graphics, List<class_5481> texts, int mouseX, int mouseY) {
        if (!texts.isEmpty()) {
            int maxTextWidth = 0;
            int iconOffset = 13;
            for (class_5481 textComponent : texts) {
                int textWidth = this.field_22793.method_30880(textComponent);
                if (!severity.isOkStatus()) {
                    textWidth += iconOffset;
                }
                if (textWidth <= maxTextWidth) continue;
                maxTextWidth = textWidth;
            }
            int startX = mouseX + 12;
            int startY = mouseY - 12;
            int heightOffset = 8;
            if (texts.size() > 1) {
                heightOffset += 2 + (texts.size() - 1) * 10;
            }
            if (startX + maxTextWidth > this.field_22789) {
                startX -= 28 + maxTextWidth;
            }
            if (startY + heightOffset + 6 > this.field_22790) {
                startY = this.field_22790 - heightOffset - 6;
            }
            class_4587 stack = graphics.method_51448();
            stack.method_22903();
            int background = severity.background;
            int fadeMin = severity.fadeMin;
            int fadeMax = severity.fadeMax;
            int zIndex = 400;
            Matrix4f matrix4f = stack.method_23760().method_23761();
            graphics.method_33284(startX - 3, startY - 4, startX + maxTextWidth + 3, startY - 3, zIndex, background, background);
            graphics.method_33284(startX - 3, startY + heightOffset + 3, startX + maxTextWidth + 3, startY + heightOffset + 4, zIndex, background, background);
            graphics.method_33284(startX - 3, startY - 3, startX + maxTextWidth + 3, startY + heightOffset + 3, zIndex, background, background);
            graphics.method_33284(startX - 4, startY - 3, startX - 3, startY + heightOffset + 3, zIndex, background, background);
            graphics.method_33284(startX + maxTextWidth + 3, startY - 3, startX + maxTextWidth + 4, startY + heightOffset + 3, zIndex, background, background);
            graphics.method_33284(startX - 3, startY - 3 + 1, startX - 3 + 1, startY + heightOffset + 3 - 1, zIndex, fadeMin, fadeMax);
            graphics.method_33284(startX + maxTextWidth + 2, startY - 3 + 1, startX + maxTextWidth + 3, startY + heightOffset + 3 - 1, zIndex, fadeMin, fadeMax);
            graphics.method_33284(startX - 3, startY - 3, startX + maxTextWidth + 3, startY - 3 + 1, zIndex, fadeMin, fadeMin);
            graphics.method_33284(startX - 3, startY + heightOffset + 2, startX + maxTextWidth + 3, startY + heightOffset + 3, zIndex, fadeMax, fadeMax);
            RenderSystem.enableDepthTest();
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            if (!severity.isOkStatus()) {
                class_289 tessellator = class_289.method_1348();
                RenderSystem.setShader(class_757::method_34540);
                class_287 bufferbuilder = tessellator.method_60827(class_293.class_5596.field_27382, class_290.field_1585);
                class_2960 icon = severity.getIcon();
                RenderSystem.setShader(class_757::method_34542);
                RenderSystem.setShaderTexture((int)0, (class_2960)icon);
                float min = -0.5f;
                float max = 8.5f;
                bufferbuilder.method_22918(matrix4f, (float)startX + min, (float)startY + min, (float)zIndex).method_22913(0.0f, 0.0f);
                bufferbuilder.method_22918(matrix4f, (float)startX + min, (float)startY + max, (float)zIndex).method_22913(0.0f, 1.0f);
                bufferbuilder.method_22918(matrix4f, (float)startX + max, (float)startY + max, (float)zIndex).method_22913(1.0f, 1.0f);
                bufferbuilder.method_22918(matrix4f, (float)startX + max, (float)startY + min, (float)zIndex).method_22913(1.0f, 0.0f);
                class_286.method_43433((class_9801)bufferbuilder.method_60800());
            }
            RenderSystem.disableBlend();
            class_4597.class_4598 bufferSource = class_310.method_1551().method_22940().method_23000();
            stack.method_22904(0.0, 0.0, (double)zIndex);
            int textOffset = severity.isOkStatus() ? 0 : iconOffset;
            for (int i = 0; i < texts.size(); ++i) {
                class_5481 textComponent = texts.get(i);
                if (textComponent != null) {
                    this.field_22793.method_22942(textComponent, (float)startX + (float)textOffset, (float)startY, -1, true, matrix4f, (class_4597)bufferSource, class_327.class_6415.field_33993, 0, 0xF000F0);
                }
                if (i == 0) {
                    startY += 2;
                }
                startY += 10;
            }
            bufferSource.method_22993();
            stack.method_22909();
        }
    }

    protected <T> void initializeGuiValue(ConfigValue<T> value, IValidationHandler handler) {
        T t = value.get();
        value.setWithValidationHandler(t, handler);
    }
}

